// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHHTMLLink.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>
#import <OmniHTML/OWScriptEventHandlerHolder.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHHTMLLink.m,v 1.6 2000/03/25 06:34:01 wjs Exp $")

@implementation OHHTMLLink

- init
{
    self = [super init];
    name = nil;
    address = nil;
    eventHandlers = [[OWScriptEventHandlerHolder allocWithZone:[self zone]] init];
    return self;
}

- (void)dealloc
{
    [address release];
    [name release];
    [eventHandlers release];
    [super dealloc];
}

- (OWAddress *)address;
{
    return address;
}

- (void)setAddress:(OWAddress *)anAddress;
{
    if (address == anAddress)
        return;
    [address release];
    address = [anAddress retain];
}

- (NSString *)name;
{
    return name;
}

- (void)setName:(NSString *)aString;
{
    if (name == aString)
        return;
    [name release];
    name = [aString retain];
}

- (NSString *)label;
{
    // Subclasses implement this to actually return something useful
    return nil;
}

- (OWScriptEventHandlerHolder *)eventHandlers;
{
    return eventHandlers;
}

//
// Drawing
//

// Subclasses that change their appearance as a link is selected or followed will override these methods.

- (void)setColorToIndex:(unsigned int)newColorIndex;
{
}

- (void)invalidateDisplay;
{
}

- (void)invalidateDisplayIncludingBorderOfWidth:(float)borderWidth;
{
}

// Scripting

- (void)followFromEvent:(NSEvent *)event;
{
    OWScriptEvent *click;

    click = [[OWScriptEvent alloc] initWithType:OWSE_Click fromEvent:event];
    [click setTarget:self action:@selector(followFromScriptEvent:)];
    [click setInstigator:self];

    [click addResponder:eventHandlers];

    [click deliverAsynchronously];
    [click release];
}

- (void)followFromScriptEvent:(OWScriptEvent *)scriptEvent;
{
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
   NSMutableDictionary *debugDictionary;

   debugDictionary = [super debugDictionary];
   if (address)
       [debugDictionary setObject:address forKey:@"address"];
   if (name)
       [debugDictionary setObject:name forKey:@"name"];
   [debugDictionary setObject:eventHandlers forKey:@"eventHandlers"];

   return debugDictionary;
}

@end



