// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHHTMLOwner.h,v 1.7 2000/03/28 17:22:39 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSLock, NSMutableArray;
@class NSTextStorage;
@class OHBasicCell, OHHTMLDocument, OHHTMLView;

@interface OHHTMLOwner : OFObject
{
    OHHTMLDocument *nonretainedHTMLDocument;
    OHHTMLView *htmlView;
    NSMutableArray *cells;
    NSLock *cellsLock;
}

- initWithHTMLViewClass:(Class)htmlViewClass htmlDocument:(OHHTMLDocument *)htmlDocument;
    // designated initializer when using this class, not a subclass

- (OHHTMLDocument *)htmlDocument;
- (void)nullifyHTMLDocument;

- (NSTextStorage *)htmlStorage;
- (OHHTMLView *)htmlView;
- (void)documentDidDeactivate:(OHHTMLView *)document;

- (void)addCell:(OHBasicCell *)aCell;

@end
