// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHHTMLOwner.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHBasicCell.h>
#import <OmniHTML/OHHTMLDocument.h>
#import <OmniHTML/OHHTMLView.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHHTMLOwner.m,v 1.16 2000/04/03 21:38:36 kc Exp $")

@interface OHHTMLOwner (Private)
@end

@implementation OHHTMLOwner

// Init and dealloc

- initWithHTMLViewClass:(Class)htmlViewClass htmlDocument:(OHHTMLDocument *)htmlDocument;
{
    if (![super init])
        return nil;

    OBASSERT(htmlDocument);

    cells = [[NSMutableArray alloc] init];
    cellsLock = [[NSLock alloc] init];

    htmlView = [[htmlViewClass allocWithZone:[self zone]] initWithHTMLOwner:self];
    nonretainedHTMLDocument = htmlDocument;
    [nonretainedHTMLDocument addHTMLOwner:self];
    
    return self;
}

- init;
{
    return [self initWithHTMLViewClass:[OHHTMLView class] htmlDocument:nil];
}

- (void)dealloc;
{
    unsigned int cellIndex, cellCount;

    [cellsLock lock];
    cellCount = [cells count];
    for (cellIndex = 0; cellIndex < cellCount; cellIndex++) {
        OHBasicCell *aCell;

        aCell = [cells objectAtIndex:cellIndex];
        [aCell nullifyHTMLOwner];
    }
    [cells removeAllObjects];
    [cellsLock unlock];

    [cells release];
    [cellsLock release];
    [htmlView nullifyHTMLOwner];
    [htmlView release];
    [super dealloc];
}


// API

- (OHHTMLDocument *)htmlDocument;
{
    return nonretainedHTMLDocument;
}

- (void)nullifyHTMLDocument;
{
    nonretainedHTMLDocument = nil;
}

- (NSTextStorage *)htmlStorage;
{
    return [htmlView textStorage];
}

- (OHHTMLView *)htmlView;
{
    return htmlView;
}

- (void)documentDidDeactivate:(OHHTMLView *)document;
{
    // Nothing needs to be done by this class
}

- (void)addCell:(OHBasicCell *)aCell;
{
    [cellsLock lock];
    [cells addObject:aCell];
    [cellsLock unlock];
}

@end

@implementation OHHTMLOwner (Private)
@end
