// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHHTMLPageContentProtocol.h,v 1.4 2000/01/20 00:28:03 kc Exp $

#import <Foundation/NSObject.h>

@class OHHTMLPageView;

@protocol OHHTMLPageContent <NSObject>

- (OHHTMLPageView *)htmlPageView;
    // The page on which we live

- (NSColor *)backgroundColor;
    // The background color for this element

// Updating the layout

- (void)cachedWidthsAreInvalid;
    // Call this when the internal widths need to be recalculated

- (void)scheduleRelayout;
    // Call this when the layout has changed (e.g. text inset)

- (void)relayout;
    // Called by scheduleRelayout (multiple schedule calls are collapsed)

@end
