// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHHTMLPageView.h,v 1.12 2000/03/25 06:34:01 wjs Exp $

#import <OmniHTML/OHHTMLView.h>

@class NSLock, NSMutableArray, NSImage, NSTextStorage;
@class OIImage;
@class OWAddress, OHForm, OHHTMLAnchor, OWWebPipeline;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet, IBAction
#import <Foundation/NSString.h>  /* for NSStringEncoding */
#import <OWF/OWContentProtocol.h>
//#import <OWF/OWWebPipeline.h>
#import <OmniHTML/OHDocumentViewProtocol.h>

@interface OHHTMLPageView : OHHTMLView <OHDocumentView, OAFindControllerTarget>
{
    id <OHDocumentFrame> nonretainedFrameView;

    NSMutableArray *links;
    NSMutableArray *namedAnchors;
    OHHTMLLink *selectedLink;

    NSMutableArray *cellsNeedingRedisplay;
    NSLock *cellsNeedingRedisplayLock;
}

+ (NSCursor *)linkCursor;

// Actions
- (IBAction)saveAllLinkedDocuments:(id)sender;
- (IBAction)saveAllLinkedImages:(id)sender;
- (IBAction)startAnimations:(id)sender;
- (IBAction)stopAnimations:(id)sender;

// Anchors
- (void)selectLink:(OHHTMLLink *)aLink;
- (void)selectLink:(OHHTMLLink *)aLink displayInAddressWell:(BOOL)shouldDisplay;
- (OHHTMLLink *)selectedLink;

- (void)followLink:(OHHTMLLink *)link withModifierFlags:(unsigned int)eventFlags;

// Communicating with our frame
- (void)displayDocumentAtAddress:(OWAddress *)address;

// Adding links and named anchors
- (void)addLink:(OHHTMLAnchor *)aLink;
- (void)addNamedAnchor:(OHHTMLAnchor *)aNamedAnchor;

// Examining links and named anchors
// NB These aren't copied, so they could mutate out from under you
- (NSArray *)links;
- (NSArray *)namedAnchors;

@end
