// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHHTMLView.h,v 1.39 2000/03/25 06:34:02 wjs Exp $

#import <AppKit/NSView.h>

@class NSLock, NSMutableArray, NSMutableSet;
@class NSAttributedString, NSLayoutManager, NSTextContainer;
@class OWAddress, OHBreak, OHHTMLAnchor, OHHTMLOwner, OHHTMLPageView;
@class OFStaticArray;
@class NSCursor;

#import <AppKit/NSNibDeclarations.h> // For IBAction
#import <AppKit/NSTextView.h> // For NSSelectionGranularity, NSSelectionAffinity
#import <OmniAppKit/OAFindControllerTargetProtocol.h>

#import <OIF/OIImageObserverProtocol.h>
#import <OWF/OWTargetProtocol.h>

#import <OmniHTML/OHBasicCell.h>
#import <OmniHTML/OHHTMLPageContentProtocol.h>
#import <OmniHTML/OHHTMLTextViewWithBackgroundImageProtocol.h>
#import <OmniHTML/OHWidthRange.h>

@interface OHHTMLView : NSView <OHHTMLPageContent, OWTarget, OIImageObserver, OHHTMLTextViewWithBackgroundImage, OASearchableContent>
{
    OHHTMLOwner *nonretainedHTMLOwner;

    NSTextStorage *textStorage;
    NSLayoutManager *layoutManager;
    NSTextContainer *textContainer;

    NSSize textContainerInset;

    OFStaticArray *paragraphs;
    OFStaticArray *words;
    OFStaticArray *lines;
    OFStaticArray *lays;

    NSMutableArray *marginalCells;
    unsigned int firstUnlaidMarginalCellIndex;

    NSMutableArray *clearBreakObjects;

    NSSelectionGranularity selectionGranularity;
    NSRange selectedRange;

    NSColor *backgroundColor;
    OWAddress *backgroundImageAddress;
    OIImage *backgroundOmniImage;
    NSImage *backgroundImage;

    struct {
        unsigned int selectedRangeContainsMultipleFonts:1;
        unsigned int selectedRangeChangedSinceLastFontCalculation:1;
        unsigned int needsRelayout:1;
        unsigned int usesOwnBackgroundColor:1;
        unsigned int cachedWidthRangeIsValid:1;
        unsigned int selectionHoldingCellIsMarginal:1;
        unsigned int isDrawingToScreen:1;
        unsigned int marginSizeIsAuthoritative:1;
    } flags;

    float requiredWidth;
    OHWidthRange cachedWidthRange;

    NSPoint draggingStartingLocationInWindow;

    unsigned int selectionHoldingCellIndexHint;
}

- (id)initWithHTMLOwner:(OHHTMLOwner *)anHTMLOwner;

// API
- (OHHTMLOwner *)htmlOwner;
- (void)nullifyHTMLOwner;

- (unsigned int)glyphIndexForPoint:(NSPoint)point fractionOfDistanceThroughGlyph:(float *)fraction isReallyOnGlyph:(BOOL *)isReallyOnGlyph;
- (const NSRect *)rectArrayForCharacterRange:(NSRange)characterRange rectCount:(unsigned int *)returnRectCountPtr;
- (const NSRect *)rectArrayForLayRange:(NSRange)layRange rectCount:(unsigned int *)returnRectCountPtr;
- (NSRect)containingRectForCharacterRange:(NSRange)characterRange;
- (NSRect)containingRectForLayRange:(NSRange)layRange;
- (void)setNeedsDisplayForCharacterRange:(NSRange)characterRange;
- (void)scrollCharacterRangeToTop:(NSRange)characterRange;
- (void)scrollCharacterRangeToVisible:(NSRange)characterRange;
- (void)scrollCellToTop:(OHBasicCell *)aCell;
- (void)scrollCellToVisible:(OHBasicCell *)aCell;
- (void)redisplayCell:(OHBasicCell *)aCell;
- (void)relayoutCell:(OHBasicCell *)aCell;
- (void)dragAddress:(OWAddress *)anAddress event:(NSEvent *)mouseDown;
- (void)dragLink:(OHHTMLLink *)aLink event:(NSEvent *)mouseDown;
- (void)setMarginSize:(NSSize)newMarginSize advisory:(BOOL)isAdvisory;
- (NSSize)marginSize;

// NSTextView look-alike
- (NSString *)string;
- (void)setBackgroundColor:(NSColor *)aColor;
- (BOOL)drawsBackground;
- (void)setTextContainerInset:(NSSize)inset;
- (NSSize)textContainerInset;
- (NSRange)selectedRange;
- (void)setSelectedRange:(NSRange)charRange;
- (void)setSelectedRange:(NSRange)charRange affinity:(NSSelectionAffinity)affinity stillSelecting:(BOOL)stillSelecting;
- (NSRange)selectionRangeForProposedRange:(NSRange)proposedSelRange granularity:(NSSelectionGranularity)granularity;
- (void)scrollRangeToVisible:(NSRange)range;

// Actions
- (IBAction)relayout:(id)sender;
- (IBAction)showSelectedLink:(id)sender;
- (IBAction)saveSelectedLink:(id)sender;
- (IBAction)newWindowWithSelectedLink:(id)sender;
- (IBAction)addSelectedLinkToBookmarks:(id)sender;
- (IBAction)jumpToSelection:(id)sender;

// Calculating dimensions
- (NSSize)pageSize;

- (OHWidthRange)widthRange;

- (void)setFrameSize:(NSSize)newSize relayout:(BOOL)shouldRelayout;
- (void)setWidth:(unsigned int)newWidth;
- (float)heightForCurrentWidth;

// Building the HTML view
- (void)appendAttributedString:(NSAttributedString *)attributedString;
- (void)setRequiredWidth:(float)aWidth;
- (void)addMarginalCell:(OHBasicCell *)cell;
- (NSArray *)marginalCells;
- (void)setValidMarginalCellCount:(unsigned int)newCount;
- (void)addClearBreakObject:(OHBreak *)breakObject;
- (NSArray *)clearBreakObjects;

// Background
- (void)setBackgroundImageAddress:(OWAddress *)anAddress;
- (BOOL)usesOwnBackgroundColor;
- (void)setUsesOwnBackgroundColor:(BOOL)newSetting;
- (void)drawBackgroundForRect:(NSRect)rect backgroundOrigin:(NSPoint)backgroundOrigin;

// OHOptionalDocumentView protocol
- (NSPoint)draggingStartingLocationInWindow;

// Context menu
- (void)showContextMenuForMouseEvent:(NSEvent *)mouseEvent;
- (id)cellOrLinkAtLocation:(NSPoint)point;
- (OHHTMLLink *)linkAtPoint:(NSPoint)location;

@end

// Access components of the text system

@interface OHHTMLView (TextSystemOnly)
- (NSTextStorage *)textStorage;
- (NSLayoutManager *)layoutManager;
- (NSTextContainer *)textContainer;
- (OFStaticArray *)paragraphs;
- (OFStaticArray *)words;
- (OFStaticArray *)lines;
- (OFStaticArray *)lays;
- (NSRange)characterRangeForWordRange:(NSRange)wordRange;
- (NSRange)glyphRangeForWordRange:(NSRange)wordRange;
@end

@interface OHHTMLView (SubclassesOnly)
- (void)laidOutContentsAtSize:(NSSize)contentSize;
// Background image handling
- (void)backgroundImageDidUpdate;
@end
