// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHLay.h,v 1.7 2000/01/20 00:28:04 kc Exp $

#import <OmniFoundation/OFStaticObject.h>

@class OHHTMLView, OHParagraph, OHWord;

#import <Foundation/NSGeometry.h> // For NSRect, etc.
#import <Foundation/NSRange.h>

@interface OHLay : OFStaticObject
{
@public
    NSRange wordRange;
    float x, width;
    float firstWordXLocationInLayoutManager;
}

- (void)drawInLineBounds:(NSRect)lineBounds maxAscent:(float)maxAscent paragraph:(OHParagraph *)paragraph selectedGlyphRange:(NSRange)selectedGlyphRange inHTMLView:(OHHTMLView *)htmlView;

- (void)getMinX:(float *)minX maxX:(float *)maxX forSelectedGlyphRange:(NSRange)selectedGlyphRange lineBounds:(NSRect)lineBounds inHTMLView:(OHHTMLView *)htmlView;
- (float)xPositionOfCharacterAtIndex:(unsigned int)characterIndex inHTMLView:(OHHTMLView *)htmlView;

- (NSComparisonResult)compareToPoint:(NSPoint)point glyphIndex:(unsigned int *)glyphIndex fractionOfDistanceThroughGlyph:(float *)fraction lineBounds:(NSRect)lineBounds paragraph:(OHParagraph *)paragraph inHTMLView:(OHHTMLView *)htmlView;

- (NSComparisonResult)compareToCharacterIndex:(unsigned int)characterIndex inHTMLView:(OHHTMLView *)htmlView;
- (NSRange)characterRangeInHTMLView:(OHHTMLView *)htmlView;

- (OHWord *)attachmentWordInHTMLView:(OHHTMLView *)htmlView;;

@end
