// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHLine.h,v 1.9 2000/01/20 00:28:05 kc Exp $

#import "OHAbstractTextRow.h"

@class OHHTMLView, OHLay, OHParagraph;

@interface OHLine : OHAbstractTextRow
{
@public
    OHParagraph *paragraph;

    NSRange layRange;
}

// Init and dealloc
- (id)initFromParagraph:(OHParagraph *)newParagraph wordIndex:(unsigned int *)firstWordIndex lastWordIndex:(unsigned int)lastWordIndex maxX:(float *)maxX bounds:(NSRect)maxBounds alignment:(NSTextAlignment)alignment attributes:(NSDictionary **)attributes attributesRange:(NSRange *)attributesRange inHTMLView:(OHHTMLView *)htmlView;

// API
- (NSRect)bounds;

- (BOOL)drawRect:(NSRect)rect selectedGlyphRange:(NSRange)selectedGlyphRange inHTMLView:(OHHTMLView *)htmlView;

- (NSComparisonResult)compareToY:(float)testY;

- (unsigned int)glyphIndexForPoint:(NSPoint)point fractionOfDistanceThroughGlyph:(float *)fraction isReallyOnGlyph:(BOOL *)isReallyOnGlyph inHTMLView:(OHHTMLView *)htmlView;

- (NSRect)rectForContainedLay:(OHLay *)lay;
- (NSRect)rectForContainedLay:(OHLay *)lay fromCharacterAtIndex:(unsigned int)characterIndex inHTMLView:(OHHTMLView *)htmlView;
- (NSRect)rectForContainedLay:(OHLay *)lay toCharacterAtIndex:(unsigned int)characterIndex inHTMLView:(OHHTMLView *)htmlView;
- (NSRect)rectForCharacterRange:(NSRange)characterRange inContainedLay:(OHLay *)lay inHTMLView:(OHHTMLView *)htmlView;

@end
