// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OHParagraph.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OmniHTML/OHHTMLView.h>

#import "OHWord.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHParagraph.m,v 1.6 2000/03/25 06:34:02 wjs Exp $")

@implementation OHParagraph

- initWithStringScanner:(OFStringScanner *)scanner wordIndex:(unsigned int *)wordIndex words:(OFStaticArray *)words attributes:(NSDictionary **)attributes attributesRange:(NSRange *)attributesRange inHTMLView:(OHHTMLView *)htmlView;
{
    NSLayoutManager *layoutManager;
    NSRange paragraphGlyphRange;

    layoutManager = [htmlView layoutManager];

    wordRange = NSMakeRange(*wordIndex, 0);

    bounds = [layoutManager lineFragmentUsedRectForGlyphAtIndex:[layoutManager glyphRangeForCharacterRange:NSMakeRange(scannerScanLocation(scanner), 1) actualCharacterRange:NULL].location effectiveRange:&paragraphGlyphRange];
    
    while (scannerHasData(scanner)) {
        OHWord *word;

        word = [words newObject];
        
        [word initWithStringScanner:scanner paragraphBounds:bounds paragraphGlyphRange:paragraphGlyphRange inHTMLView:htmlView];

        wordRange.length++;
        
        if (word->type == OHWordTypeReturn)
            break;
    }

    [self getLineHeightAndAscentForAttributes:attributes attributesRange:attributesRange inHTMLView:htmlView];

    *wordIndex += wordRange.length;
    
    return self;
}

- (float)positionOfTabStopFollowingPosition:(float)aPosition;
{
    // Should calculate this to be the width of eight spaces in the current font
    const float tabWidth = 56.0;

    return aPosition - fmod(aPosition, tabWidth) + tabWidth;
}

@end
