// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHWord.h,v 1.9 2000/03/25 06:34:02 wjs Exp $

#import <OmniFoundation/OmniFoundation.h>

#import <OmniHTML/OHBasicCell.h>
#import <OmniHTML/OHWidthRange.h>

@class OFStringScanner;
@class OHHTMLView;

typedef enum {
    OHWordTypeLetters, OHWordTypeSpaces, OHWordTypeTab, OHWordTypeReturn, OHWordTypeAttachment,
} OHWordType;

@interface OHWord : OFStaticObject
{
    float width;
@public
    NSRange characterRange;
    float x;
    OHWordType type;
}

- initWithStringScanner:(OFStringScanner *)scanner paragraphBounds:(NSRect)paragraphBounds paragraphGlyphRange:(NSRange)paragraphGlyphRange inHTMLView:(OHHTMLView *)htmlView;

- (OHBasicCell *)attachmentCellInHTMLView:(OHHTMLView *)htmlView;
- (float)widthInHTMLView:(OHHTMLView *)htmlView;

- (OHWidthRange)widthRangeInHTMLView:(OHHTMLView *)htmlView;

- (void)setTabWidth:(float)newWidth;
    // Tabs widths vary with the distance to the next tab stop

@end
