// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniNetworking/ONServiceEntry.h,v 1.8 2000/01/19 23:35:01 kc Exp $

#import <OmniBase/OBObject.h>

#import "FrameworkDefines.h"

@interface ONServiceEntry : OBObject
{
    NSString *serviceName;
    NSString *protocolName;
    struct servent *serviceEntry;
}

+ serviceEntryNamed:(NSString *)aServiceName protocolName:(NSString *)aProtocolName;

- (NSString *)serviceName;
- (NSString *)protocolName;
- (unsigned short int)portNumber;

- (const struct servent *)serviceEntry;

@end

// This is not an exhaustive list, but more than most people will ever use
OmniNetworking_EXTERN NSString *ONServiceEntryIPProtocolName;
OmniNetworking_EXTERN NSString *ONServiceEntryICMPProtocolName;
OmniNetworking_EXTERN NSString *ONServiceEntryTCPProtocolName;
OmniNetworking_EXTERN NSString *ONServiceEntryUDPProtocolName;

// Exceptions which may be raised by this class
OmniNetworking_EXTERN NSString *ONServiceNotFoundExceptionName;
