// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "ONHostAddress.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniBase/system.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniNetworking/ONHostAddress.m,v 1.9 2000/01/19 23:35:00 kc Exp $")

@interface ONHostAddress (PrivateAPI)
- initWithInternetAddress:(const struct in_addr *)anInternetAddress;
@end

@implementation ONHostAddress

+ (ONHostAddress *)broadcastAddress;
{
    struct in_addr broadcastAddress;

    broadcastAddress.s_addr = INADDR_BROADCAST;
    return [self hostAddressWithInternetAddress: &broadcastAddress];
}

+ (ONHostAddress *)hostAddressWithInternetAddress:(const struct in_addr *)anInternetAddress;
{
    return [[[self alloc] initWithInternetAddress:anInternetAddress] autorelease];
}

+ (ONHostAddress *)anyAddress;
{
    struct in_addr address;

    address.s_addr = INADDR_ANY;

    return [self hostAddressWithInternetAddress: &address];
}

- initWithInternetAddress:(const struct in_addr *)anInternetAddress;
{
    if (![self init])
	return nil;

    if (!anInternetAddress) {
        [self release];
        return nil;
    }

    internetAddress = (struct in_addr *)NSZoneMalloc(NULL, sizeof(struct in_addr));
    *internetAddress = *anInternetAddress;

    return self;
}

- (void)dealloc;
{
    NSZoneFree(NULL, internetAddress);
    [super dealloc];
}

- (const struct in_addr *)internetAddress;
{
    return internetAddress;
}

- (BOOL) isMulticastAddress;
{
    // Either inet_addr returns addresses in host byte order
    // or this macro expects them in host byte order.  It is
    // not clear from the documentation (such as it is).
    return IN_MULTICAST(ntohl(internetAddress->s_addr));
}


@end

@implementation ONHostAddress (Debugging)

- (NSString *)descriptionWithLocale:(NSDictionary *)locale indent:(unsigned int)level
{
    return [NSString stringWithCString:inet_ntoa(*[self internetAddress])];
}

- (NSString *)shortDescription;
{
    return [self description];
}

@end
