// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniNetworking/ONHost.h,v 1.11 2000/09/13 05:01:14 kc Exp $

#import <OmniBase/OBObject.h>

@class NSArray, NSDate, NSMutableArray;
@class ONHostAddress;

#import <Foundation/NSDate.h> // For NSTimeInterval

@interface ONHost : OBObject
{
    NSString *hostname;
    NSString *canonicalHostname;
    NSMutableArray *addresses;
    NSDate *expirationDate;
}

+ (NSString *)domainName;
+ (NSString *)localHostname;

+ (ONHost *)hostForHostname:(NSString *)hostname;
+ (ONHost *)hostForAddress:(ONHostAddress *)anAddress;

+ (void)flushCache;
+ (void)setDefaultTimeToLiveTimeInterval:(NSTimeInterval)newValue;

+ (BOOL)isDottedQuadString:(NSString *)string;

- (NSString *)hostname;
- (NSArray *)addresses;
- (NSString *)canonicalHostname;
- (NSString *)domainName;

- (void)flushFromHostCache;

@end

#import "FrameworkDefines.h"

// Exceptions which may be raised by this class
OmniNetworking_EXTERN NSString *ONHostNotFoundExceptionName;
OmniNetworking_EXTERN NSString *ONHostNameLookupErrorExceptionName;
OmniNetworking_EXTERN NSString *ONHostHasNoAddressesExceptionName;
OmniNetworking_EXTERN NSString *ONGetHostByNameNotFoundExceptionName;
