// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "ONSocket.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniNetworking/ONSocket.m,v 1.13 2001/02/15 15:14:58 kc Exp $")

static NSStringEncoding defaultStringEncoding;
static unsigned int defaultReadBufferSize;

@implementation ONSocket

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
	return;
    initialized = YES;

    defaultStringEncoding = NSISOLatin1StringEncoding;
    defaultReadBufferSize = 2048;
}

- init
{
    if (![super init])
	return nil;

    stringEncoding = defaultStringEncoding;
    readBufferSize = defaultReadBufferSize;

    return self;
}

- (unsigned int)readBytes:(unsigned int)byteCount intoBuffer:(void *)aBuffer;
{
    OBRequestConcreteImplementation(self, _cmd);
    return 0;
}

- (unsigned int)writeBytes:(unsigned int)byteCount fromBuffer:(const void *)aBuffer;
{
    OBRequestConcreteImplementation(self, _cmd);
    return 0;
}

- (void)abortSocket;
{
}

- (BOOL)isReadable;
{
    return YES;
}

- (BOOL)isWritable;
{
    return YES;
}

@end

@implementation ONSocket (General)

+ (void)setDefaultStringEncoding:(NSStringEncoding)aStringEncoding;
{
    defaultStringEncoding = aStringEncoding;
}

+ (void)setDefaultReadBufferSize:(int)aSize;
{
    defaultReadBufferSize = aSize;
}

- (void)writeData:(NSData *)data;
{
    const void *bytes;
    unsigned int length;

    bytes = [data bytes];
    length = [data length];
    while (length) {
        unsigned int bytesWritten;

        bytesWritten = [self writeBytes:length fromBuffer:bytes];
        if (bytesWritten > 0) {
	    if (bytesWritten > length)
		break;
	    length -= bytesWritten;
	    bytes += bytesWritten;
        }
    }
}

- (void)writeString:(NSString *)string;
{
    [self writeData:[string dataUsingEncoding:stringEncoding allowLossyConversion:YES]];
}

- (void)writeFormat:(NSString *)aFormat, ...;
{
    va_list argList;
    NSString *formattedString;

    va_start(argList, aFormat);
    formattedString = [[NSString alloc] initWithFormat:aFormat arguments:argList];
    va_end(argList);
    [self writeString:formattedString];
    [formattedString release];
}

- (void)readData:(NSMutableData *)data;
{
    void *dataBytes;
    unsigned int dataLength, bytesRead;

    dataLength = [data length];
    dataBytes = [data mutableBytes];
    bytesRead = [self readBytes:dataLength intoBuffer:dataBytes];
    [data setLength:bytesRead];
}

- (NSData *)readData;
{
    NSMutableData *data;

    data = [NSMutableData dataWithLength:readBufferSize];
    [self readData:data];
    return [data length] > 0 ? data : nil;
}

- (NSString *)readString;
{
    NSData *data;
    
    data = [self readData];
    if (!data)
	return nil;
    return [[[NSString alloc] initWithData:data encoding:stringEncoding] autorelease];
}
    
- (NSStringEncoding)stringEncoding;
{
    return stringEncoding;
}

- (void)setStringEncoding:(NSStringEncoding)aStringEncoding;
{
    stringEncoding = aStringEncoding;
}

- (void)setReadBufferSize:(int)aSize;
{
    readBufferSize = aSize;
}

@end
