// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniNetworking/ONHost-InternalAPI.h,v 1.9 2002/03/09 01:54:06 kc Exp $

#import "ONHost.h"

#if defined(sun)

// ONHOST_USE_THREADSAFE_RESOLVER should be defined on those systems which have gethostbyname_r() (such as Solaris)
#define ONHOST_USE_THREADSAFE_RESOLVER

#elif defined(__APPLE__) || defined(NeXT)

// ONHOST_USE_THREADSAFE_LOOKUPD_GETHOSTBYNAME should be defined on systems which have lookup daemons (such as OPENSTEP/Mach).
#define ONHOST_USE_THREADSAFE_LOOKUPD_GETHOSTBYNAME

#else

// If neither of the above two options are defined, ONHost will use the ONGetHostByName tool to perform hostname lookups in a separate task.

#endif

@interface ONHost (ONInternalAPI)
+ (void)_raiseExceptionForHostErrorNumber:(int)hostErrorNumber hostname:(NSString *)hostname;

- _initWithHostname:(NSString *)aHostname;

- (BOOL)isExpired;

- (void)_lookupHostInfoByPipe;
#ifdef ONHOST_USE_THREADSAFE_RESOLVER
- (void)_lookupHostInfoUsingThreadSafeResolver;
#endif
@end


#ifdef ONHOST_USE_THREADSAFE_LOOKUPD_GETHOSTBYNAME

@class NSRecursiveLock;

@interface ONHost (ONLookupdHack)
- (void)_lookupHostInfoByLookupDaemon;
@end

OmniNetworking_PRIVATE_EXTERN BOOL ONHostNameLookupDebug;
OmniNetworking_PRIVATE_EXTERN NSRecursiveLock *ONHostLookupLock;

#endif
