// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniNetworking/ONHostAddress.h,v 1.11 2002/03/09 01:54:06 kc Exp $

#import <OmniBase/OBObject.h>

@interface ONHostAddress : OBObject
{
    struct in_addr *internetAddress;
}

+ (ONHostAddress *)hostAddressWithInternetAddress:(const struct in_addr *)anInternetAddress;
+ (ONHostAddress *)addressWithIPv4UnsignedLong:(unsigned long)anAddress;

+ (ONHostAddress *)anyAddress;
+ (ONHostAddress *)loopbackAddress;
+ (ONHostAddress *)broadcastAddress;

- (const struct in_addr *)internetAddress;
- (BOOL)isMulticastAddress;

@end
