// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "ONHostAddress.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniBase/system.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniNetworking/ONHostAddress.m,v 1.12 2002/03/09 01:54:06 kc Exp $")

@interface ONHostAddress (PrivateAPI)
- initWithInternetAddress:(const struct in_addr *)anInternetAddress;
@end

@implementation ONHostAddress

+ (ONHostAddress *)hostAddressWithInternetAddress:(const struct in_addr *)anInternetAddress;
{
    return [[[self alloc] initWithInternetAddress:anInternetAddress] autorelease];
}

+ (ONHostAddress *)addressWithIPv4UnsignedLong:(unsigned long)anAddress;
{
    struct in_addr address;

    address.s_addr = anAddress;
    return [self hostAddressWithInternetAddress:&address];
}

+ (ONHostAddress *)anyAddress;
{
    return [self addressWithIPv4UnsignedLong:INADDR_ANY];
}

+ (ONHostAddress *)loopbackAddress;
{
    return [self addressWithIPv4UnsignedLong:INADDR_LOOPBACK];
}

+ (ONHostAddress *)broadcastAddress;
{
    return [self addressWithIPv4UnsignedLong:INADDR_BROADCAST];
}

- initWithInternetAddress:(const struct in_addr *)anInternetAddress;
{
    if (![self init])
	return nil;

    if (!anInternetAddress) {
        [self release];
        return nil;
    }

    internetAddress = (struct in_addr *)NSZoneMalloc(NULL, sizeof(struct in_addr));
    *internetAddress = *anInternetAddress;

    return self;
}

- (void)dealloc;
{
    NSZoneFree(NULL, internetAddress);
    [super dealloc];
}

- (const struct in_addr *)internetAddress;
{
    return internetAddress;
}

- (BOOL) isMulticastAddress;
{
    // Either inet_addr returns addresses in host byte order
    // or this macro expects them in host byte order.  It is
    // not clear from the documentation (such as it is).
    return IN_MULTICAST(ntohl(internetAddress->s_addr));
}


@end

@implementation ONHostAddress (Debugging)

- (NSString *)descriptionWithLocale:(NSDictionary *)locale indent:(unsigned int)level
{
    return [NSString stringWithCString:inet_ntoa(*[self internetAddress])];
}

- (NSString *)shortDescription;
{
    return [self description];
}

@end
