// Copyright 1999-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniNetworking/ONInterface.h,v 1.10 2002/03/09 01:54:06 kc Exp $

#import <OmniBase/OBObject.h>

// ONInterface represents a network interface.  This might be a ethernet card, the loopback interface, a slip or ppp link or the like.

// Some work will probably be needed to get this to build on NT or Solaris.  Rather than potentially breaking the build there, only build this on Mach for now.  OPENSTEP (version 4.x) does not have a bunch of the headers & stuff used by ONInterface; rather than figure out what to prune off, I'm just disabling ONInterface entirely under older versions

#if defined(__MACH__) && (OBOperatingSystemMajorVersion > 4)
#define HAVE_ONInterface
#endif

#ifdef HAVE_ONInterface

@class ONHostAddress;
@class NSArray;
@class NSData;

typedef enum _ONInterfaceType {
    ONUnknownInterfaceType,
    ONEtherInterfaceType, // used for loopback too
    ONPPPInterfaceType,
    ONFDDIInterfaceType
} ONInterfaceType;

@interface ONInterface : OBObject
{
    NSString *name;
    ONHostAddress *interfaceAddress;
    ONHostAddress *destinationAddress; // for point-to-point links
    ONHostAddress *broadcastAddress;
    ONHostAddress *netmaskAddress; // not sure if this is the right way to represent this
    NSData *linkLayerAddress; // for ethernet, this is the MAC address

    ONInterfaceType interfaceType;
    unsigned int maximumTransmissionUnit;
    unsigned int flags;
}

+ (NSArray *)interfaces;
+ (NSString *)stringForLinkLayerAddress:(NSData *)address;

- (NSString *)name;
- (ONHostAddress *)interfaceAddress;
- (ONHostAddress *)destinationAddress;
- (ONHostAddress *)broadcastAddress;
- (ONHostAddress *)netmaskAddress;
- (NSData *)linkLayerAddress;
- (NSString *)linkLayerAddressString;
- (ONInterfaceType)interfaceType;

- (unsigned int)maximumTransmissionUnit;

- (BOOL)isUp;
- (BOOL)supportsBroadcast;
- (BOOL)isLoopback;
- (BOOL)isPointToPoint;
- (BOOL)supportsAddressResolutionProtocol;
- (BOOL)supportsPromiscuousMode;
- (BOOL)isSimplex;
- (BOOL)supportsMulticast;

@end

#endif /* HAVE_ONInterface */

