#include <mach/mach_types.h>
#include <mach/kmod.h>

#import "OmniPPCPerformanceCounterDriver.h"

#import "../../Framework/OPPCUtils.h"
#import "../../Framework/OPPCEvents.h"

#import <sys/errno.h>


// Copied from sys/systm.h -- wasn't able to import it
extern struct sysent {		/* system call table */
        short		sy_narg;	/* number of args */
        short		sy_parallel;/* can execute in parallel */
        int		(*sy_call)();	/* implementing function */
} sysent[];
extern int nsysent;

// Our system call

int OmniPPCPerformanceCounterDriver_syscall(void *proc,
                                            struct OPPCArguments *args,
                                            int *retval)
{
    IOLog("OmniPPCPerformanceCounterDriver_syscall:\n");

    switch (args->operation) {
        case OPPCSetupOperation:
        {
            unsigned int setting = 0;

            if (args->args.setup.disableCountingUnconditionally)
                setting |= (1<<31);
            if (args->args.setup.disableCountingInSupervisorMode)
                setting |= (1<<30);
            if (args->args.setup.disableCountingInUserMode)
                setting |= (1<<29);
            if (args->args.setup.disableCountingForMarkedTasks)
                setting |= (1<<28);
            if (args->args.setup.disableCountingForUnmarkedTasks)
                setting |= (1<<27);

            IOLog("OmniPPCPerformanceCounterDriver_syscall: setting = 0x%08x\n", setting);
            OPPC_SET_SPR(setting, OPPC_SPR_MMCR0);
            break;
        }
        case OPPCSelectOperation:
        {
            unsigned int setting0, setting1;

            if (args->args.select.event1 < 0 || args->args.select.event1 > OPPC_PMC12_LAST) {
                IOLog("OPPC_SelectPerformanceCounters: %d is not a valid value for event%d.\n", args->args.select.event1, 1);
                return EINVAL;
            }
            if (args->args.select.event2 < 0 || args->args.select.event2 > OPPC_PMC12_LAST) {
                IOLog("OPPC_SelectPerformanceCounters: %d is not a valid value for event%d.\n", args->args.select.event2, 2);
                return EINVAL;
            }
            if (args->args.select.event3 < 0 || args->args.select.event3 > OPPC_PMC3_LAST || args->args.select.event3 == OPPC_PMC3_RESERVED0) {
                IOLog("OPPC_SelectPerformanceCounters: %d is not a valid value for event%d.\n", args->args.select.event3, 3);
                return EINVAL;
            }
            if (args->args.select.event4 < 0 || args->args.select.event4 > OPPC_PMC4_LAST || args->args.select.event4 == OPPC_PMC4_RESERVED0) {
                IOLog("OPPC_SelectPerformanceCounters: %d is not a valid value for event%d.\n", args->args.select.event4, 4);
                return EINVAL;
            }

            OPPC_GET_SPR(setting0, OPPC_SPR_MMCR0);
            IOLog("OPPC_SelectPerformanceCounters: setting0 = 0x%08x\n", setting0);

            setting0 &= ~((1<<12)-1);    // Clear the bottom twelve bits
            setting0 |= (args->args.select.event1 << 6);   // Put in the PMC1SELECT field
            setting0 |= args->args.select.event2;          // Put in the PMC2SELECT field

            IOLog("OPPC_SelectPerformanceCounters: setting0 = 0x%08x\n", setting0);
            OPPC_SET_SPR(setting0, OPPC_SPR_MMCR0);


            setting1 = 0;  // we'll be setting all the non-reseved bits
            setting1 |= (args->args.select.event3 << 27);
            setting1 |= (args->args.select.event4 << 22);
            IOLog("OPPC_SelectPerformanceCounters: setting1 = 0x%08x\n", setting1);
            OPPC_SET_SPR(setting1, OPPC_SPR_MMCR1);

            break;
        }
        case OPPCResetOperation:
        {
            if (args->args.reset.reset1)
                OPPC_SET_SPR(0, OPPC_SPR_PMC1);
            if (args->args.reset.reset2)
                OPPC_SET_SPR(0, OPPC_SPR_PMC2);
            if (args->args.reset.reset3)
                OPPC_SET_SPR(0, OPPC_SPR_PMC3);
            if (args->args.reset.reset4)
                OPPC_SET_SPR(0, OPPC_SPR_PMC4);
            break;
        }
        default:
        {
            return EINVAL;
        }
    }
    
    return 0;
}

extern int nosys();


static int didInstall = 0;

kern_return_t OmniPPCPerformanceCounterDriver_start(struct kmod_info *ki, void *data)
{
    unsigned int value;

    IOLog("OmniPPCPerformanceCounterDriver: OmniPPCPerformanceCounterDriver_start called\n");

    // Get HID0 to check the SGE bit
    OPPC_GET_SPR(value, 1008);
    IOLog("HID0 = 0x%08x\n", value);

#warning Verify that this is a PPC750?

    // Make sure system call slot is available

    if (nsysent < OPPC_SYSCALL) {
        IOLog("OmniPPCPerformanceCounterDriver: Cannot install system call -- nsysent = %d, OPPC_SYSCALL = %d\n", nsysent, OPPC_SYSCALL);
        return KERN_FAILURE;
    }

    if (sysent[OPPC_SYSCALL].sy_call != nosys) {
        IOLog("OmniPPCPerformanceCounterDriver: Cannot install system call -- 0x%08x is already registered at %d\n",
              sysent[OPPC_SYSCALL].sy_call, OPPC_SYSCALL);
        return KERN_FAILURE;
    }

    // Install new system call
    sysent[OPPC_SYSCALL].sy_narg     = sizeof(struct OPPCArguments) / sizeof(int);
    sysent[OPPC_SYSCALL].sy_parallel = 0;
    sysent[OPPC_SYSCALL].sy_call     = OmniPPCPerformanceCounterDriver_syscall;
    didInstall = 1;

    IOLog("OmniPPCPerformanceCounterDriver: system call installed\n");

    return KERN_SUCCESS;
}

kern_return_t OmniPPCPerformanceCounterDriver_finalize(struct kmod_info *ki, void *data)
{
    IOLog("OmniPPCPerformanceCounterDriver: OmniPPCPerformanceCounterDriver_finalize called\n");

    if (didInstall) {
        IOLog("OmniPPCPerformanceCounterDriver: removing system call\n");
        sysent[OPPC_SYSCALL].sy_narg     = 0;
        sysent[OPPC_SYSCALL].sy_parallel = 0;
        sysent[OPPC_SYSCALL].sy_call     = nosys;
    }

    return KERN_SUCCESS;
}

