#import "OTTimer.h"

#import <stdio.h>

static int    conversionFactorSet = 0;
static double secondsPerStampUnit = 0.0;
static double highFactor = 4294967296.0;

double OTStampToSeconds(const OTStamp *stamp)
{
    double steps;

    if (!conversionFactorSet) {
        conversionFactorSet = 1;
        secondsPerStampUnit = OTSecondsPerStampUnit();
    }
    
    steps = (double)stamp->ul.high * highFactor + (double)stamp->ul.low;
    return steps * secondsPerStampUnit;
}
